﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;


namespace printString {
    static class printStr {

        static int printingPosition;
        static Font printFont;
        static string printingText;

        static public void print(string text) {
            printingText = text;
            printingPosition = 0;
            printFont = new Font("ＭＳ Ｐゴシック", 10);
            System.Drawing.Printing.PrintDocument pd = new System.Drawing.Printing.PrintDocument();
            //ダイアログ表示
            PrintDialog dilg = new PrintDialog();
            dilg.PrinterSettings = new System.Drawing.Printing.PrinterSettings();
            DialogResult ans = dilg.ShowDialog();
            if(ans == DialogResult.OK) {
                //イベントハンドラ追加し印刷開始
                pd.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);
                pd.Print();
            }
        }

        static private void pd_PrintPage(object sender,
            System.Drawing.Printing.PrintPageEventArgs e) {
            if(printingPosition == 0) {
                //改行記号を'\n'に統一する
                printingText = printingText.Replace("\r\n", "\n");
                printingText = printingText.Replace("\r", "\n");
            }

            //印刷する初期位置を決定
            int x = e.MarginBounds.Left;
            int y = e.MarginBounds.Top;

            //1ページに収まらなくなるか、印刷する文字がなくなるかまでループ
            while(e.MarginBounds.Bottom > y + printFont.Height &&
                printingPosition < printingText.Length) {
                string line = "";
                for(; ; ) {
                    //印刷する文字がなくなるか、
                    //改行の時はループから抜けて印刷する
                    if(printingPosition >= printingText.Length || printingText[printingPosition] == '\n') {
                        printingPosition++;
                        break;
                    }
                    //一文字追加し、印刷幅を超えるか調べる
                    line += printingText[printingPosition];
                    if(e.Graphics.MeasureString(line, printFont).Width > e.MarginBounds.Width) {
                        //印刷幅を超えたため、折り返す
                        line = line.Substring(0, line.Length - 1);
                        break;
                    }
                    //印刷文字位置を次へ
                    printingPosition++;
                }
                //一行書き出す
                e.Graphics.DrawString(line, printFont, Brushes.Black, x, y);
                //次の行の印刷位置を計算
                y += (int)printFont.GetHeight(e.Graphics);
            }

            //次のページがあるか調べる
            if(printingPosition >= printingText.Length) {
                e.HasMorePages = false;
                //初期化する
                printingPosition = 0;
            }
            else
                e.HasMorePages = true;
        }
    }
}
